<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- CDA R2 Tyylitiedosto, HL7 Finland 19.8.2008 -->
<!-- Muutoshistoria -->
<!-- 2008.08.19: Pivitetty muuttuneen Header-mrittelyn mukaiseksi. AE -->
<!-- 2006.09.25: Pivitetty muuttuneen Header-mrittelyn mukaiseksi. Listty kuvalinkin esittminen (AVE) -->
<!-- 2004.12.12: Listty Sovittujen Header-elementtien muotoilu katseltaviksi. -->
<!-- 2004.12.12: Listty content-elementin attribuutin revised-ksittely. Eli lisykset ja poistot merkitn.-->
<!-- 2004.09.28: Listty xsl:output lause, jossa sanotaan merkkivalikoimaksi ISO-8859-1. -->
<!-- Muista pivitt tyylitiedoston versio html-head tagin jlkeen -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:hl7fi="urn:hl7finland" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="html" indent="yes" version="4.01" encoding="ISO-8859-1" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
	<!-- CDA document -->
	<xsl:template match="/">
		<xsl:apply-templates select="n1:ClinicalDocument"/>
	</xsl:template>
	<xsl:template match="n1:ClinicalDocument">
		<html>
			<head/>
			<style>
				<xsl:comment>				
					 .class-normal {  font-style: normal; font-weight: normal; }
					 .class-bold {  font-style: normal; font-weight: bold; }
					 .class-underline { font-style: normal; font-weight: normal; text-decoration: underline; }
					 .class-italics { font-style: italic; font-weight: normal; }
					 .class-emphasis {  font-style: normal; font-weight: normal; background-color:yellow; }
					 .class-delete {  font-style: normal; font-weight: normal; text-decoration:line-through; }
					 .class-insert {  font-style: normal; font-weight: normal; text-decoration:underline; }
					 .class-caption {  font-style: normal; font-weight: bold;  }
	          	</xsl:comment>
			</style>
			<xsl:comment>				
              HL7 Finland  R2 Tyylitiedosto: Open CDA_2006
            </xsl:comment>
			<body>
				<em class="class-caption">
					<span style="font-weight:bold; color:green;">
						<h3>
							<xsl:text>CDA R2 tuloste (CDA_Fi_body.xsl 1.1.2009)</xsl:text>
						</h3>
					</span>
				</em>
				<xsl:apply-templates select="n1:componentOf/n1:encompassingEncounter/n1:responsibleParty/n1:assignedEntity/n1:representedOrganization"/>
				<xsl:apply-templates select="n1:recordTarget"/>
				<xsl:apply-templates select="n1:componentOf/n1:encompassingEncounter/n1:responsibleParty/n1:assignedEntity/n1:representedOrganization"/>
				<xsl:apply-templates select="n1:componentOf/n1:encompassingEncounter/n1:effectiveTime"/>
				<xsl:apply-templates select="n1:componentOf/n1:encompassingEncounter/n1:encounterParticipant"/>
				<xsl:apply-templates select="n1:documentationOf"/>
				<br/>
				<xsl:apply-templates select="n1:component/n1:structuredBody"/>
			</body>
		</html>
	</xsl:template>
	<!-- 13 recordTarget potilaan tiedot -->
	<xsl:template match="n1:recordTarget">
		<em class="class-caption">
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>Potilas</xsl:text>
				<br/>
			</span>
			<xsl:for-each select="n1:patientRole/n1:id">
				<span style="font-weight:bold; color:green;">
					<xsl:text>henkiltunnus: </xsl:text>
				</span>
				<xsl:value-of select="@root"/>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="@extension"/>
				<br/>
			</xsl:for-each>
			<span style="font-weight:bold; color:green;">
				<xsl:text>nimi: </xsl:text>
			</span>
			<xsl:value-of select="n1:patientRole/n1:patient/n1:name/n1:family"/>
			<xsl:text>, </xsl:text>
			<xsl:value-of select="n1:patientRole/n1:patient/n1:name/n1:given"/>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>syntymaika: </xsl:text>
			</span>
			<xsl:call-template name="effectivetime">
				<xsl:with-param name="effectivetime" select="n1:patientRole/n1:patient/n1:birthTime"/>
			</xsl:call-template>
			<br/>
			<span style="font-weight:bold; color:green;">
				<xsl:text>sukupuoli: </xsl:text>
			</span>
			<xsl:for-each select="n1:patientRole/n1:patient/n1:administrativeGenderCode">
				<xsl:value-of select="@code"/>,&#160;<xsl:value-of select="@displayName"/>&#160;-- koodisto:&#160; 
				<xsl:value-of select="@codeSystem"/>,&#160;<xsl:value-of select="@codeSystemName"/>
			</xsl:for-each>
			<br/>
			<br/>
		</em>
	</xsl:template>
	<!-- 23. Annettu palvelu -->
	<xsl:template match="n1:documentationOf">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Annettu palvelu: </xsl:text>
			</span>
			<xsl:value-of select="n1:serviceEvent/n1:code/@code"/>,&#160;<xsl:value-of select="n1:serviceEvent/n1:code/@displayName"/>&#160;-- koodisto:&#160; 
				<xsl:value-of select="n1:serviceEvent/n1:code/@codeSystem"/>,&#160;<xsl:value-of select="n1:serviceEvent/n1:code/@codeSystemName"/>
			<xsl:text> ajalta: </xsl:text>
			<xsl:call-template name="effectivetime">
				<xsl:with-param name="effectivetime" select="n1:serviceEvent/n1:effectiveTime"/>
			</xsl:call-template>
			<br/>
		</em>
	</xsl:template>
	<!-- 26.1 componentOf Palvelutapahtumatunnus -->
	<xsl:template match="n1:componentOf/n1:encompassingEncounter/n1:id">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<h3>
					<xsl:text>Palvelutapahtuman tiedot</xsl:text>
				</h3>
				<xsl:text>2.2.26.1 Palvelutapahtumatunnus: </xsl:text>
			</span>
			<xsl:value-of select="@root"/>
			<xsl:choose>
				<xsl:when test="@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
		</em>
	</xsl:template>
	<!-- 26.2 componentOf Palvelutapahtumatunnus -->
	<xsl:template match="n1:componentOf/n1:encompassingEncounter/n1:code">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>2.2.26.2 Palvelutapahtumaluokka: </xsl:text>
			</span>
			<xsl:value-of select="@code"/>,&#160;<xsl:value-of select="@displayName"/>&#160;-- koodisto:&#160; 
			<xsl:value-of select="@codeSystem"/>,&#160;<xsl:value-of select="@codeSystemName"/>
			<br/>
		</em>
	</xsl:template>
	<!-- 26.3 componentOf Hoitoaika -->
	<xsl:template match="n1:componentOf/n1:encompassingEncounter/n1:effectiveTime">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Palvelutapahtuman kokonaishoitoaika: </xsl:text>
			</span>
			<xsl:call-template name="effectivetime">
				<xsl:with-param name="effectivetime" select="."/>
			</xsl:call-template>
			<br/>
		</em>
	</xsl:template>
	<!-- 26.4 componentOf Palvelunantaja -->
	<xsl:template match="n1:componentOf/n1:encompassingEncounter/n1:responsibleParty/n1:assignedEntity/n1:representedOrganization">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Palvelunantaja: </xsl:text>
			</span>
			<xsl:value-of select="n1:id/@root"/>
			<xsl:choose>
				<xsl:when test="n1:id/@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="n1:id/@extension"/>
				</xsl:when>
			</xsl:choose>
			<xsl:text>,&#160;</xsl:text>
			<xsl:value-of select="n1:name"/>
			<br/>
		</em>
	</xsl:template>
	<!-- 26.5 componentOf Palvelutapahtumatunnus -->
	<xsl:template match="n1:componentOf/n1:encompassingEncounter/n1:encounterParticipant">
		<em class="class-caption">
			<span style="font-weight:bold; color:green;">
				<xsl:text>Palveluyksikn hoitoaika: </xsl:text>
			</span>
			<xsl:call-template name="effectivetime">
				<xsl:with-param name="effectivetime" select="n1:time"/>
			</xsl:call-template>
			<span style="font-weight:bold; color:green;">
				<xsl:text> palveluyksikk: </xsl:text>
			</span>
			<xsl:value-of select="n1:assignedEntity/n1:representedOrganization/n1:name"/>
			<br/>
		</em>
	</xsl:template>
	<!-- StructuredBody -->
	<xsl:template match="n1:component/n1:structuredBody">
		<xsl:apply-templates select="n1:component/n1:section"/>
	</xsl:template>
	<!-- Component/Section -->
	<xsl:template match="n1:component/n1:section">
		<!-- section xml ID -->
		<em class="class-caption">
			<xsl:choose>
				<xsl:when test="@ID">
					<span style="font-weight:bold; color:blue;">
						<xsl:text>section xml ID: </xsl:text>
					</span>
					<xsl:value-of select="@ID"/>
					<br/>
				</xsl:when>
			</xsl:choose>
			<!-- siirr objektin/merkinnn osoite html:n 15.9.2008  Antero Ensio-->
			<xsl:choose>
				<xsl:when test="@ID">
					<xsl:element name="a">
						<xsl:attribute name="name"><xsl:value-of select="@ID"/></xsl:attribute>
						<xsl:text/>
					</xsl:element>
				</xsl:when>
			</xsl:choose>
			<!-- siirr objektin/merkinnn osoite html:n 15.9.2008  Antero Ensio-->
			<xsl:choose>
				<xsl:when test="n1:id/@root">
					<xsl:element name="a">
						<xsl:attribute name="name"><xsl:text>id</xsl:text><xsl:value-of select="n1:id/@root"/><xsl:choose><xsl:when test="n1:id/@extension"><xsl:text>.</xsl:text><xsl:value-of select="n1:id/@extension"/></xsl:when></xsl:choose></xsl:attribute>
					</xsl:element>
				</xsl:when>
			</xsl:choose>
		</em>
		<!-- section id -->
		<em class="class-caption">
			<xsl:choose>
				<xsl:when test="n1:id/@root">
					<span style="font-weight:bold; color:blue;">
						<xsl:text>section id: </xsl:text>
					</span>
					<xsl:value-of select="n1:id/@root"/>
					<xsl:choose>
						<xsl:when test="n1:id/@extension">
							<xsl:text>.</xsl:text>
							<xsl:value-of select="n1:id/@extension"/>
						</xsl:when>
					</xsl:choose>
					<br/>
				</xsl:when>
			</xsl:choose>
		</em>
		<!-- section code -->
		<em class="class-caption">
			<span style="font-weight:bold; color:blue;">
				<xsl:text>section code: </xsl:text>
			</span>
			<xsl:call-template name="code">
				<xsl:with-param name="code" select="n1:code"/>
			</xsl:call-template>
			<!-- merkinnn tekij tai merkintn osallistuja -->
			<xsl:call-template name="author">
				<xsl:with-param name="author" select="."/>
			</xsl:call-template>
			<!-- span style="font-weight:bold; color:blue;">
				<xsl:value-of select="n1:code/@displayName"/>
				<xsl:choose>
					<xsl:when test="n1:code/n1:translation/n1:qualifier/n1:value">
						<xsl:text>, </xsl:text>
						<xsl:value-of select="n1:code/n1:translation/n1:qualifier/n1:value/@displayName"/>
					</xsl:when>
				</xsl:choose>
			</span -->
			<ul>
				<xsl:choose>
					<xsl:when test="n1:author/n1:functionCode/@code='MER'">
						<xsl:choose>
							<xsl:when test="n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name">
								<xsl:text>merkinnn palveluyksikk: </xsl:text>
								<xsl:value-of select="n1:author/n1:assignedAuthor/n1:representedOrganization/n1:name"/>
								<br/>
							</xsl:when>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family">
								<xsl:text>merkinnn tekij: </xsl:text>
								<xsl:value-of select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:suffix"/>
								<xsl:text> </xsl:text>
								<xsl:value-of select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family"/>
								<xsl:text>, </xsl:text>
								<xsl:value-of select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name/n1:given"/>
								<br/>
							</xsl:when>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="n1:author/n1:time/@value">
								<xsl:text>merkinnn aika: </xsl:text>
								<xsl:call-template name="effectivetime">
									<xsl:with-param name="effectivetime" select="n1:author/n1:time"/>
								</xsl:call-template>
								<br/>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
			</ul>
		</em>
		<xsl:apply-templates select="n1:title"/>
		<ul>
			<xsl:apply-templates select="n1:text"/>
			<!--   Ydintieto n1:entry/n1:observation -->
			<xsl:for-each select="n1:entry/n1:observation">
				<span style="font-weight:bold; color:red;">
					<br/>
					<xsl:text>observation</xsl:text>
				</span>
				<br/>
				<!--   Ydintieto laboratorio -->
				<xsl:choose>
					<xsl:when test="n1:code/@codeSystem='1.2.246.537.6.3.2002'">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>ydintieto: LAB</xsl:text>
						</span>
						<xsl:choose>
							<xsl:when test="n1:id/@root">
								<xsl:element name="a">
									<xsl:attribute name="name"><xsl:text>id</xsl:text><xsl:value-of select="n1:id/@root"/><xsl:choose><xsl:when test="n1:id/@extension"><xsl:text>.</xsl:text><xsl:value-of select="n1:id/@extension"/></xsl:when></xsl:choose></xsl:attribute>
								</xsl:element>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
				<!-- Ydintieto diagnoosi 3.2.2 -->
				<xsl:choose>
					<xsl:when test="n1:value/@codeSystem='1.2.246.537.6.1.1996'">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>ydintieto: diagnoosi 3.2.2</xsl:text>
							<br/>
						</span>
					</xsl:when>
				</xsl:choose>
				<!-- Ydintieto  apuvline -->
				<xsl:choose>
					<xsl:when test="n1:code/@codeSystem='1.2.246.537.6.12.999.2003'">
						<!--  Ydintieto  kenttkoodi  apuvline -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='6'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>apuvline</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi  veriryhm -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='7'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>veriryhm</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi  toimintakyky-->
						<xsl:choose>
							<xsl:when test="n1:code/@code='8'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>toimintakyky</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi  todistukset ja lausunnot-->
						<xsl:choose>
							<xsl:when test="n1:code/@code='9'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>todistukset ja lausunnot</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi jatkohoito -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='11'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>jatkohoito</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi  palvelutapahtuma-->
						<xsl:choose>
							<xsl:when test="n1:code/@code='12'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>palvelutapahtuma</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!-- Ydintieto  kenttkoodi riskitieto -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='13'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>riskitieto</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi hoidon tarve -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='15'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>hoidon tarve</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi toiminto -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='16'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>toiminto</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi hoidon tulos -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='17'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>hoidon tulos</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi hoitoisuus -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='18'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>hoitoisuus</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  kenttkoodi sairasloma -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='26'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>sairasloma</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
						<!--  Ydintieto  Kuljetusjrjestelyt -->
						<xsl:choose>
							<xsl:when test="n1:code/@code='27'">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>ydintieto: </xsl:text>
								</span>
								<xsl:text>Kuljetusjrjestelyt</xsl:text>
								<br/>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
				<!--  Oservation yhteiset tiedot-->
				<xsl:choose>
					<xsl:when test="n1:id">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>id: </xsl:text>
						</span>
						<xsl:value-of select="n1:id/@root"/>
						<xsl:choose>
							<xsl:when test="n1:id/@extension">
								<xsl:text>.</xsl:text>
								<xsl:value-of select="n1:id/@extension"/>
							</xsl:when>
						</xsl:choose>
						<br/>
					</xsl:when>
				</xsl:choose>
				<span style="font-weight:bold; color:blue;">
					<xsl:text>koodi: </xsl:text>
				</span>
				<xsl:call-template name="code">
					<xsl:with-param name="code" select="n1:code"/>
				</xsl:call-template>
				<xsl:choose>
					<xsl:when test="n1:statusCode">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>statuskoodi: </xsl:text>
						</span>
						<xsl:value-of select="n1:statusCode/@code"/>
						<br/>
					</xsl:when>
				</xsl:choose>
				<span style="font-weight:bold; color:blue;">
					<xsl:text>aika: </xsl:text>
				</span>
				<xsl:call-template name="effectivetime">
					<xsl:with-param name="effectivetime" select="n1:effectiveTime"/>
				</xsl:call-template>
				<br/>
				<xsl:call-template name="value">
					<xsl:with-param name="value" select="n1:value"/>
				</xsl:call-template>
				<br/>
				<xsl:choose>
					<xsl:when test="n1:interpretationCode">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>tulkintakoodi: </xsl:text>
						</span>
						<xsl:call-template name="code">
							<xsl:with-param name="code" select="n1:interpretationCode"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="n1:subject">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>potilaan ht: </xsl:text>
						</span>
						<xsl:value-of select="n1:subject/n1:relatedSubject/n1:code/@code"/>
						<br/>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="n1:specimen">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>specimen koodi: </xsl:text>
						</span>
						<xsl:call-template name="value">
							<xsl:with-param name="value" select="n1:specimen/n1:specimenRole/n1:specimenPlayingEntity/n1:code"/>
						</xsl:call-template>
						<br/>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="n1:referenceRange">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>viitearvo: </xsl:text>
						</span>
						<xsl:value-of select="n1:referenceRange/n1:observationRange/n1:value/n1:low/@value"/>
						<xsl:text>-</xsl:text>
						<xsl:value-of select="n1:referenceRange/n1:observationRange/n1:value/n1:high/@value"/>
						<xsl:text>/</xsl:text>
						<xsl:value-of select="n1:referenceRange/n1:observationRange/n1:text"/>
						<br/>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="n1:performer">
						<span style="font-weight:bold; color:red;">
							<xsl:text>performer</xsl:text>
						</span>
						<br/>
						<xsl:choose>
							<xsl:when test="n1:performer/n1:time">
								<span style="font-weight:bold; color:blue;">
									<xsl:text>tekoaika: </xsl:text>
								</span>
								<xsl:call-template name="effectivetime">
									<xsl:with-param name="effectivetime" select="n1:performer/n1:time"/>
								</xsl:call-template>
								<br/>
								<span style="font-weight:bold; color:blue;">
									<xsl:text>tutkimuksen tekijn id: </xsl:text>
								</span>
								<xsl:value-of select="n1:performer/n1:assignedEntity/n1:id/@root"/>
								<xsl:choose>
									<xsl:when test="n1:performer/n1:assignedEntity/n1:id/@extension">
										<xsl:text>.</xsl:text>
										<xsl:value-of select="n1:performer/n1:assignedEntity/n1:id/@extension"/>
									</xsl:when>
								</xsl:choose>
								<br/>
								<span style="font-weight:bold; color:blue;">
									<xsl:text>tutkimuksen tekijn nimi: </xsl:text>
								</span>
								<xsl:value-of select="n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:family"/>
								<xsl:text>, </xsl:text>
								<xsl:value-of select="n1:performer/n1:assignedEntity/n1:assignedPerson/n1:name/n1:given"/>
								<br/>
								<span style="font-weight:bold; color:blue;">
									<xsl:text>tutkimuksen teon palveluyksikk: </xsl:text>
								</span>
								<xsl:value-of select="n1:performer/n1:assignedEntity/n1:representedOrganization/n1:name"/>
								<xsl:text>, </xsl:text>
								<xsl:value-of select="n1:performer/n1:assignedEntity/n1:representedOrganization/n1:id/@root"/>
								<xsl:choose>
									<xsl:when test="n1:performer/n1:assignedEntity/n1:representedOrganization/n1:id/@extension">
										<xsl:text>.</xsl:text>
										<xsl:value-of select="n1:performer/n1:assignedEntity/n1:representedOrganization/n1:id/@extension"/>
									</xsl:when>
								</xsl:choose>
								<br/>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
				<xsl:call-template name="author">
					<xsl:with-param name="author" select="."/>
				</xsl:call-template>
				<xsl:call-template name="entryRelationship">
					<xsl:with-param name="entryRelationship" select="."/>
				</xsl:call-template>
				<xsl:call-template name="reference">
					<xsl:with-param name="reference" select="."/>
				</xsl:call-template>
			</xsl:for-each>
			<!--   Ydintieto n1:entry/n1:procedure -->
			<xsl:for-each select="n1:entry/n1:procedure">
				<span style="font-weight:bold; color:red;">
					<br/>
					<xsl:text>procedure</xsl:text>
				</span>
				<br/>
				<!-- Ydintieto:  toimenpiteet ja  leikkaukset 3.2.3 -->
				<xsl:choose>
					<xsl:when test="n1:code/@codeSystem='1.2.246.537.6.2.2007'">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>ydintieto: toimenpiteet ja  leikkaukset 3.2.3</xsl:text>
							<br/>
						</span>
						<span style="font-weight:bold; color:blue;">
							<xsl:text>aika: </xsl:text>
						</span>
						<xsl:call-template name="effectivetime">
							<xsl:with-param name="effectivetime" select="n1:effectiveTime"/>
						</xsl:call-template>
						<br/>
						<span style="font-weight:bold; color:blue;">
							<xsl:text>koodi: </xsl:text>
						</span>
						<xsl:call-template name="code">
							<xsl:with-param name="code" select="n1:code"/>
						</xsl:call-template>
						<span style="font-weight:bold; color:blue;">
							<xsl:text>ydintieto diagnoosi: </xsl:text>
						</span>
						<xsl:call-template name="value">
							<xsl:with-param name="value" select="n1:value"/>
						</xsl:call-template>
						<br/>
						<xsl:call-template name="author">
							<xsl:with-param name="author" select="."/>
						</xsl:call-template>
						<xsl:call-template name="entryRelationship">
							<xsl:with-param name="entryRelationship" select="."/>
						</xsl:call-template>
						<xsl:call-template name="reference">
							<xsl:with-param name="reference" select="."/>
						</xsl:call-template>
						<br/>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<!--   Ydintieto n1:entry/n1:encounter -->
			<xsl:for-each select="n1:entry/n1:encounter">
				<span style="font-weight:bold; color:red;">
					<xsl:text>encounter</xsl:text>
					<br/>
				</span>
				<!--   Ydintieto 3.2.5 Hoitojakso/kynti -->
				<span style="font-weight:bold; color:blue;">
					<xsl:text>ydintieto: 3.2.5 hoitojakso/kynti</xsl:text>
					<br/>
				</span>
				<xsl:choose>
					<xsl:when test="n1:id">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>id: </xsl:text>
						</span>
						<xsl:value-of select="n1:id/@root"/>
						<xsl:choose>
							<xsl:when test="n1:id/@extension">
								<xsl:text>.</xsl:text>
								<xsl:value-of select="n1:id/@extension"/>
							</xsl:when>
						</xsl:choose>
						<br/>
					</xsl:when>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="n1:id">
						<span style="font-weight:bold; color:blue;">
							<xsl:text>text: </xsl:text>
						</span>
						<xsl:value-of select="n1:text/."/>
						<br/>
					</xsl:when>
				</xsl:choose>
				<span style="font-weight:bold; color:blue;">
					<xsl:text>aika: </xsl:text>
				</span>
				<xsl:call-template name="effectivetime">
					<xsl:with-param name="effectivetime" select="n1:effectiveTime"/>
				</xsl:call-template>
				<br/>
				<span style="font-weight:bold; color:blue;">
					<xsl:text>koodi: </xsl:text>
				</span>
				<xsl:call-template name="code">
					<xsl:with-param name="code" select="n1:code"/>
				</xsl:call-template>
				<xsl:call-template name="author">
					<xsl:with-param name="author" select="."/>
				</xsl:call-template>
				<xsl:call-template name="entryRelationship">
					<xsl:with-param name="entryRelationship" select="."/>
				</xsl:call-template>
				<br/>
				<br/>
			</xsl:for-each>
			<xsl:apply-templates select="n1:component/n1:section"/>
		</ul>
	</xsl:template>
	<!--   Title  -->
	<xsl:template match="n1:title">
		<span style="font-weight:bold; color:green;">
			<xsl:value-of select="."/>
		</span>
	</xsl:template>
	<!--   Text   -->
	<xsl:template match="n1:text">
		<xsl:apply-templates/>
	</xsl:template>
	<!--   br   -->
	<xsl:template match="n1:br">
		<br/>
	</xsl:template>
	<!--   paragraph  -->
	<xsl:template match="n1:paragraph">
		<xsl:apply-templates/>
		<br/>
	</xsl:template>
	<!--   content  -->
	<xsl:template match="n1:content">
		<xsl:choose>
			<xsl:when test='@revised="delete"'>
				<em class="class-delete">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="insert"'>
				<em class="class-insert">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Bold"'>
				<em class="class-bold">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Underline"'>
				<em class="class-underline">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Italics"'>
				<em class="class-italics">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test='@revised="Emphasis"'>
				<em class="class-emphasis">
					<xsl:apply-templates/>
				</em>
			</xsl:when>
			<xsl:when test="@ID">
				<em class="class-emphasis">
					<xsl:element name="a">
						<xsl:attribute name="name"><xsl:value-of select="@ID"/></xsl:attribute>
						<xsl:value-of select="."/>
					</xsl:element>
				</em>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--   list  -->
	<xsl:template match="n1:list">
		<!--   listan otsikko  -->
		<xsl:if test="n1:caption">
			<span style="font-weight:bold; ">
				<xsl:apply-templates select="n1:caption"/>
			</span>
		</xsl:if>
		<!-- Jokainen listan alkio -->
		<xsl:for-each select="n1:item">
			<li>
				<!-- Lista-alkion elementti-->
				<xsl:apply-templates/>
			</li>
		</xsl:for-each>
	</xsl:template>
	<!--   caption  -->
	<xsl:template match="n1:caption">
		<xsl:apply-templates/>
		<xsl:text>: </xsl:text>
	</xsl:template>
	<!--      Tables
	 Koko alipuu kopioidaan sellaisenaan.
	 CAPTION elementin lapset ksitelln mahdollisilla muilla templateilla
  -->
	<xsl:template match="n1:table|n1:table/n1:caption|n1:thead|n1:tfoot|n1:tbody|n1:colgroup|n1:col|n1:tr|n1:th|n1:td">
		<xsl:copy>
			<xsl:apply-templates select="*|@*|text()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="n1:table/n1:caption">
		<span style="font-weight:bold; ">
			<xsl:apply-templates/>
		</span>
	</xsl:template>
	<!--   author  -->
	<xsl:template name="author">
		<xsl:for-each select="n1:author">
			<!-- merkinnn tekij -->
			<!-- merkintn osallistuja -->
			<span style="font-weight:bold; color:red;">
				<xsl:text>author</xsl:text>
				<br/>
			</span>
			<span style="font-weight:bold; color:blue;">
				<xsl:text>ydintieto: 3.2.1 ammattihenhil/laite/palveluyksikk</xsl:text>
				<br/>
			</span>
			<span style="font-weight:bold; color:blue;">
				<xsl:value-of select="n1:functionCode/@displayName"/>&#160;
				<xsl:text>id: </xsl:text>
			</span>
			<xsl:value-of select="n1:assignedAuthor/n1:id/@root"/>
			<xsl:choose>
				<xsl:when test="n1:assignedAuthor/n1:id/@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="n1:assignedAuthor/n1:id/@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
			<xsl:choose>
				<xsl:when test="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family">
					<span style="font-weight:bold; color:blue;">
						<xsl:value-of select="n1:functionCode/@displayName"/>&#160;
						<xsl:text> nimi: </xsl:text>
					</span>
					<xsl:value-of select="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:given"/>
					<xsl:text>, </xsl:text>
					<xsl:value-of select="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family"/>
					<br/>
				</xsl:when>
			</xsl:choose>
			<span style="font-weight:bold; color:blue;">
				<xsl:value-of select="n1:functionCode/@displayName"/>&#160;
				<xsl:text>rooli: </xsl:text>
			</span>
			<xsl:value-of select="n1:functionCode/@code"/>,&#160;
				<xsl:value-of select="n1:functionCode/@displayName"/>&#160;-- koodisto:&#160; 
				<xsl:value-of select="n1:functionCode/@codeSystem"/>,&#160;
				<xsl:value-of select="n1:functionCode/@codeSystemName"/>
			<br/>
			<span style="font-weight:bold; color:blue;">
				<xsl:value-of select="n1:functionCode/@displayName"/>&#160;
				<xsl:text>kirjausaika: </xsl:text>
			</span>
			<xsl:call-template name="effectivetime">
				<xsl:with-param name="effectivetime" select="n1:time"/>
			</xsl:call-template>
			<br/>
			<xsl:choose>
				<xsl:when test="n1:assignedAuthor/n1:assignedPerson/n1:name/n1:family">
					<span style="font-weight:bold; color:blue;">
						<xsl:value-of select="n1:functionCode/@displayName"/>&#160;
						<xsl:text>palveluyksikk: </xsl:text>
					</span>
					<xsl:value-of select="n1:assignedAuthor/n1:representedOrganization/n1:id/@root"/>
					<xsl:choose>
						<xsl:when test="n1:assignedAuthor/n1:representedOrganization/n1:id/@extension">
							<xsl:text>.</xsl:text>
							<xsl:value-of select="n1:assignedAuthor/n1:representedOrganization/n1:id/@extension"/>
						</xsl:when>
					</xsl:choose>
					<xsl:text>, </xsl:text>
					<xsl:value-of select="n1:assignedAuthor/n1:representedOrganization/n1:name"/>
					<br/>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<!--   entryRelationship  -->
	<xsl:template name="entryRelationship">
		<xsl:for-each select="n1:entryRelationship">
			<span style="font-weight:bold; color:red;">
				<xsl:text>entryRelationship</xsl:text>
				<br/>
			</span>
			<xsl:choose>
				<xsl:when test="n1:observation/n1:id">
					<span style="font-weight:bold; color:blue;">
						<xsl:text>id: </xsl:text>
					</span>
					<xsl:value-of select="n1:observation/n1:id/@root"/>
					<xsl:choose>
						<xsl:when test="n1:observation/n1:id/@extension">
							<xsl:text>.</xsl:text>
							<xsl:value-of select="n1:observation/n1:id/@extension"/>
						</xsl:when>
					</xsl:choose>
					<br/>
				</xsl:when>
			</xsl:choose>
			<span style="font-weight:bold; color:blue;">
				<xsl:text>kenttkoodi: </xsl:text>
			</span>
			<xsl:value-of select="n1:observation/n1:code/@code"/>,&#160;
			<xsl:value-of select="n1:observation/n1:code/@displayName"/>&#160;-- koodisto:&#160; 
			<xsl:value-of select="n1:observation/n1:code/@codeSystem"/>,&#160;
			<xsl:value-of select="n1:observation/n1:code/@codeSystemName"/>
			<br/>
			<span style="font-weight:bold; color:blue;">
				<xsl:text>aika: </xsl:text>
			</span>
			<xsl:call-template name="effectivetime">
				<xsl:with-param name="effectivetime" select="n1:observation/n1:effectiveTime"/>
			</xsl:call-template>
			<br/>
			<xsl:call-template name="value">
				<xsl:with-param name="value" select="n1:observation/n1:value"/>
			</xsl:call-template>
			<br/>
		</xsl:for-each>
	</xsl:template>
	<!--  reference  -->
	<xsl:template name="reference">
		<xsl:for-each select="n1:reference">
			<span style="font-weight:bold; color:red;">
				<xsl:text>reference</xsl:text>
				<br/>
			</span>
			<span style="font-weight:bold; color:blue;">
				<xsl:text>id: </xsl:text>
			</span>
			<xsl:value-of select="n1:externalObservation/n1:id/@root"/>
			<xsl:choose>
				<xsl:when test="n1:externalObservation/n1:id/@extension">
					<xsl:text>.</xsl:text>
					<xsl:value-of select="n1:externalObservation/n1:id/@extension"/>
				</xsl:when>
			</xsl:choose>
			<br/>
		</xsl:for-each>
	</xsl:template>
	<!--   code  -->
	<xsl:template name="code">
		<xsl:param name="code"/>
		<xsl:value-of select="$code/@code"/>,&#160;<xsl:value-of select="$code/@displayName"/>&#160;-- koodisto:&#160; 
		<xsl:value-of select="$code/@codeSystem"/>,&#160;<xsl:value-of select="$code/@codeSystemName"/>
		<br/>
		<xsl:choose>
			<xsl:when test="$code/n1:qualifier/n1:name">
				<span style="font-weight:bold; color:blue;">
					<xsl:text>qualifier name: </xsl:text>
				</span>
				<xsl:value-of select="$code/n1:qualifier/n1:name/@code"/>,&#160;
				<xsl:value-of select="$code/n1:qualifier/n1:name/@displayName"/>&#160;-- koodisto:&#160; 
				<xsl:value-of select="$code/n1:qualifier/n1:name/@codeSystem"/>,&#160;
				<xsl:value-of select="$code/n1:qualifier/n1:name/@codeSystemName"/>
				<br/>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$code/n1:qualifier/n1:value">
				<span style="font-weight:bold; color:blue;">
					<xsl:text>qualifier value: </xsl:text>
				</span>
				<xsl:value-of select="$code/n1:qualifier/n1:value/@code"/>,&#160;
				<xsl:value-of select="$code/n1:qualifier/n1:value/@displayName"/>&#160;-- koodisto:&#160; 
				<xsl:value-of select="$code/n1:qualifier/n1:value/@codeSystem"/>,&#160;
				<xsl:value-of select="$code/n1:qualifier/n1:value/@codeSystemName"/>
				<br/>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$code/n1:originalText/n1:reference">
				<xsl:element name="a">
					<xsl:attribute name="href"><xsl:value-of select="$code/n1:originalText/n1:reference/@value"/></xsl:attribute>
					<!-- Jokin teksti, jota klikkaamalla selain aktivoi haun linkill -->
					<xsl:text> tekstin linkki</xsl:text>
				</xsl:element>
			</xsl:when>
		</xsl:choose>
		<!-- section lis code -->
		<xsl:for-each select="$code/n1:translation/n1:qualifier/n1:value">
			<span style="font-weight:bold; color:blue;">
				<xsl:text>liskoodi: </xsl:text>
			</span>
			<xsl:value-of select="@code"/>,&#160;
			<xsl:value-of select="@displayName"/>&#160;-- koodisto:&#160; 
			<xsl:value-of select="@codeSystem"/>,&#160;
			<xsl:value-of select="@codeSystemName"/>
			<br/>
		</xsl:for-each>
	</xsl:template>
	<!--   value  -->
	<xsl:template name="value">
		<xsl:param name="value"/>
		<span style="font-weight:bold; color:blue;">
			<xsl:text>value: </xsl:text>
			<xsl:value-of select="$value/@xsi:type"/>&#160;&#160;	
		</span>
		<xsl:choose>
			<xsl:when test='$value/@xsi:type="ED"'>
				<xsl:value-of select="$value/."/>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test='$value/@xsi:type="PQ"'>
				<xsl:value-of select="$value/@value"/>&#160;
				<span style="font-weight:bold; color:blue;">
					<xsl:text>yksikk: </xsl:text>
				</span>
				<xsl:value-of select="$value/@unit"/>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test='$value/@xsi:type="CE"'>
				<xsl:value-of select="$value/@code"/>,&#160;
			<xsl:value-of select="$value/@displayName"/>&#160;
			<span style="font-weight:bold; color:blue;">
				<xsl:text>-- koodisto: </xsl:text>
			</span>
			<xsl:value-of select="$value/@codeSystem"/>,&#160;
			<xsl:value-of select="$value/@codeSystemName"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$value/@code">
						<xsl:call-template name="code">
							<xsl:with-param name="code" select="$value"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test='$value/@xsi:type="MO"'>
				<xsl:value-of select="$value/@value"/>
				<xsl:value-of select="$value/@currency"/>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$value/n1:originalText/n1:reference">
				<xsl:element name="a">
					<xsl:attribute name="href"><xsl:value-of select="$value/n1:originalText/n1:reference/@value"/></xsl:attribute>
					<!-- Jokin teksti, jota klikkaamalla selain aktivoi haun linkill -->
					<xsl:text> tekstin linkki</xsl:text>
				</xsl:element>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Nimen tulostaminen -->
	<xsl:template name="getName">
		<xsl:apply-templates select="n1:name"/>
	</xsl:template>
	<!-- Pivmrn ja kellonajan tai -vlien muotoilu ulkoasuun pp.kk.vvvv klo hh:mm:ss 2008-09-25 -->
	<xsl:template name="effectivetime">
		<xsl:param name="effectivetime"/>
		<xsl:choose>
			<!-- pivmr -->
			<xsl:when test="$effectivetime/@value">
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="$effectivetime/@value"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- pivmr -->
				<xsl:choose>
					<xsl:when test="$effectivetime/n1:low/@value">
						<xsl:call-template name="datesingle">
							<xsl:with-param name="pdatesingle" select="$effectivetime/n1:low/@value"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
				<xsl:text> - </xsl:text>
				<xsl:choose>
					<xsl:when test="$effectivetime/n1:high/@value">
						<xsl:call-template name="datesingle">
							<xsl:with-param name="pdatesingle" select="$effectivetime/n1:high/@value"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Pivmrn ja kellonajan tai -vlien muotoilu ulkoasuun pp.kk.vvvv klo hh:mm:ss -->
	<xsl:template name="date">
		<xsl:param name="date"/>
		<xsl:choose>
			<!-- pivmrvli -->
			<xsl:when test="contains($date,'..')">
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="substring-before ($date,'..')"/>
				</xsl:call-template>
				<xsl:text> - </xsl:text>
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="substring-after ($date,'..')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- pivmr -->
				<xsl:call-template name="datesingle">
					<xsl:with-param name="pdatesingle" select="$date"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="datesingle">
		<xsl:param name="pdatesingle"/>
		<!-- pp-->
		<xsl:if test='substring ($pdatesingle, 7, 2)!=""'>
			<xsl:value-of select="format-number(substring ($pdatesingle,7, 2),0)"/>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- kk-->
		<xsl:if test='substring ($pdatesingle, 5, 2)!=""'>
			<xsl:value-of select="format-number(substring ($pdatesingle,5, 2),0)"/>
			<xsl:text>.</xsl:text>
		</xsl:if>
		<!-- vvvv-->
		<xsl:value-of select="substring ($pdatesingle, 1, 4)"/>
		<xsl:text/>
		<xsl:if test='substring ($pdatesingle, 9, 2)!=""'>
			<xsl:text> klo </xsl:text>
			<!-- hh-->
			<xsl:value-of select="substring ($pdatesingle,9, 2)"/>
		</xsl:if>
		<!-- mm -->
		<xsl:if test='substring ($pdatesingle, 11, 2)!=""'>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="substring ($pdatesingle,11, 2)"/>
		</xsl:if>
		<!-- ss -->
		<xsl:if test='substring ($pdatesingle, 13, 2)!=""'>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="substring ($pdatesingle,13, 2)"/>
		</xsl:if>
	</xsl:template>
	<!-- 	Stylecode processing   
	  Supports Bold, Underline and Italics display

-->
	<xsl:template match="//n1:*[@styleCode]">
		<xsl:if test="@styleCode='Bold'">
			<xsl:element name="b">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="@styleCode='Italics'">
			<xsl:element name="i">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="@styleCode='Underline'">
			<xsl:element name="u">
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Italics') and not (contains(@styleCode, 'Underline'))">
			<xsl:element name="b">
				<xsl:element name="i">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Italics'))">
			<xsl:element name="b">
				<xsl:element name="u">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Bold'))">
			<xsl:element name="i">
				<xsl:element name="u">
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and contains(@styleCode, 'Bold')">
			<xsl:element name="b">
				<xsl:element name="i">
					<xsl:element name="u">
						<xsl:apply-templates/>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- 	Superscript or Subscript   -->
	<xsl:template match="n1:sup">
		<xsl:element name="sup">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="n1:sub">
		<xsl:element name="sub">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<!--   RenderMultiMedia 
renderMultiMedia.referencedObject -attribuutista poimitaan xml-ID viittaus vastaavaan rakenteisessa muodossa olevaan observationMedia-elementtiin ja laitetaan se apumuuttujaan imageRef
 -->
	<xsl:template match="n1:renderMultiMedia">
		<xsl:variable name="imageRef" select="@referencedObject"/>
		<!-- Haetaan xml-ID:n avulla vastaava observationMedia -->
		<xsl:if test="//n1:observationMedia[@ID=$imageRef]">
			<!-- Tulostetaan linkki kuvaan -->
			<!-- a-elementin href-attribuuttiin laitetaan kuvan osoite ja nimi, tss tapauksessa esim. linkki -->
			<xsl:element name="a">
				<!-- Oletetaan, kaikki kuvat ovat saatavilla samasta palvelusta riippumatta OID root-arvosta -->
				<!-- Oletetaan, ett kuva on tiedostossa, jonka nimi = extension-attribuutin arvo -->
				<xsl:attribute name="href"><xsl:text>http://193.185.85.122/csp/cdar2/displayImage.csp?acNumber=</xsl:text><xsl:value-of select="//n1:observationMedia[@ID=$imageRef]/n1:id/@extension"/></xsl:attribute>
				<!-- Jokin teksti, jota klikkaamalla selain aktivoi haun linkill -->
				<xsl:text> Katso</xsl:text>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!--   RenderMultiMedia  -->
	<xsl:template match="n1:renderMultiMedia">
		<xsl:element name="a">
			<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
			<!-- Jokin teksti, jota klikkaamalla selain aktivoi haun linkill -->
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<!--   linkHtml 15.9.2008 Antero Ensio -->
	<xsl:template match="n1:linkHtml">
		<xsl:element name="a">
			<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
			<!-- Jokin teksti, jota klikkaamalla selain aktivoi haun linkill -->
			<!-- 2009-02-08 -->
			<xsl:text>linkki</xsl:text>
			<!--xsl:value-of select="."/-->
		</xsl:element>
	</xsl:template>
	<!--   linkHtml 15.9.2008 Antero Ensio ???-->
	<xsl:template match="n1:originalText/n1:reference">
		<xsl:element name="a">
			<xsl:attribute name="href"><xsl:value-of select="@value"/></xsl:attribute>
			<!-- Jokin teksti, jota klikkaamalla selain aktivoi haun linkill -->
			<xsl:text>linkki</xsl:text>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
